/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.tfc.objects.entity;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.dries007.tfc.api.registries.TFCRegistries;
import net.dries007.tfc.api.types.Tree;
import net.dries007.tfc.objects.items.wood.ItemBoatTFC;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.client.CPacketSteerBoat;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class EntityBoatTFC
extends EntityBoat {
    private static final DataParameter<String> WOOD_NAME = EntityDataManager.func_187226_a(EntityBoatTFC.class, (DataSerializer)DataSerializers.field_187194_d);

    public EntityBoatTFC(World worldIn) {
        super(worldIn);
    }

    public EntityBoatTFC(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    @Nullable
    public Tree getWood() {
        return TFCRegistries.TREES.getValuesCollection().stream().filter(x -> x.getRegistryName().func_110623_a().equalsIgnoreCase((String)this.field_70180_af.func_187225_a(WOOD_NAME))).findFirst().orElse(null);
    }

    public void setWood(@Nullable Tree wood) {
        String woodName = "";
        if (wood != null) {
            woodName = wood.getRegistryName().func_110623_a().toLowerCase();
        }
        this.field_70180_af.func_187227_b(WOOD_NAME, (Object)woodName);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(WOOD_NAME, (Object)"");
    }

    public Item func_184455_j() {
        Tree wood = this.getWood();
        if (wood != null) {
            return ItemBoatTFC.get(wood);
        }
        return super.func_184455_j();
    }

    public void func_70071_h_() {
        this.field_184471_aG = this.field_184469_aF;
        this.field_184469_aF = this.func_184449_t();
        this.field_184474_h = this.field_184469_aF != EntityBoat.Status.UNDER_WATER && this.field_184469_aF != EntityBoat.Status.UNDER_FLOWING_WATER ? 0.0f : (this.field_184474_h += 1.0f);
        if (!this.field_70170_p.field_72995_K && this.field_184474_h >= 60.0f) {
            this.func_184226_ay();
        }
        if (this.func_70268_h() > 0) {
            this.func_70265_b(this.func_70268_h() - 1);
        }
        if (this.func_70271_g() > 0.0f) {
            this.func_70266_a(this.func_70271_g() - 1.0f);
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K) {
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        this.func_184447_s();
        if (this.func_184186_bw()) {
            if (this.func_184188_bt().isEmpty() || !(this.func_184188_bt().get(0) instanceof EntityPlayer)) {
                this.func_184445_a(false, false);
            }
            this.func_184450_w();
            if (this.field_70170_p.field_72995_K) {
                this.func_184443_x();
                this.field_70170_p.func_184135_a((Packet)new CPacketSteerBoat(this.func_184457_a(0), this.func_184457_a(1)));
            }
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        } else {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        for (int i = 0; i <= 1; ++i) {
            if (this.func_184457_a(i)) {
                SoundEvent soundevent;
                if (!this.func_174814_R() && (double)(this.field_184470_f[i] % ((float)Math.PI * 2)) <= 0.7853981633974483 && ((double)this.field_184470_f[i] + (double)0.3926991f) % (Math.PI * 2) >= 0.7853981633974483 && (soundevent = this.func_193047_k()) != null) {
                    Vec3d vec3d = this.func_70676_i(1.0f);
                    double d0 = i == 1 ? -vec3d.field_72449_c : vec3d.field_72449_c;
                    double d1 = i == 1 ? vec3d.field_72450_a : -vec3d.field_72450_a;
                    this.field_70170_p.func_184148_a(null, this.field_70165_t + d0, this.field_70163_u, this.field_70161_v + d1, soundevent, this.func_184176_by(), 1.0f, 0.8f + 0.4f * this.field_70146_Z.nextFloat());
                }
                this.field_184470_f[i] = (float)((double)this.field_184470_f[i] + (double)0.3926991f);
                continue;
            }
            this.field_184470_f[i] = 0.0f;
        }
        this.func_145775_I();
    }

    protected void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        Tree wood = this.getWood();
        if (wood != null) {
            compound.func_74778_a("Wood", this.getWood().getRegistryName().func_110623_a().toLowerCase());
        }
    }

    protected void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("Wood")) {
            this.field_70180_af.func_187227_b(WOOD_NAME, (Object)compound.func_74779_i("Wood"));
        }
    }
}

